function C = cov0(data);
% C = cov0(data);
% Program computes the sum-of-squares-products matrix ave[z(i)z(i)^H], 
% i.e. the covariance matrix with fixed center at the origin 
%
% INPUT data := data matrix with observations as row vectors!
% OUTPUT   C := sample covariance 
% (c) Esa Ollila (esollila@wooster.hut.fi), 
% Signal Processing Laboratory, Helsinki University of Technology(c) 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[n k]=size(data);
C = data.'*conj(data)/n; 
if k > 1, 
% We get rid of (possible) infinitesimal imaginary parts on the diagonal 
C(1:(k+1):k^2) = real(C(1:(k+1):k^2)); 
hC = C'; % Hermitian of C 
% We force the matrix C to be Hermitian - due to finite sample precision, 
% it may not be Hermitian  
C(repmat(1:k,k,1) > repmat(1:k,k,1)') = hC(repmat(1:k,k,1) > repmat(1:k,k,1)'); 
end 