function C = pcov0(data);
% C = pcov0(data);
% Program calculates the sample pseudo-covariance matrix with fixed 
% center at the origin 
%
% INPUT data := data matrix with observations as row vectors!
% OUTPUT   C := sample pseudo-covariance matrix 
% (c) Esa Ollila (esollila@wooster.hut.fi), 
% Signal Processing Laboratory, Helsinki University of Technology(c) 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[n k]=size(data);
C = data.'*data/n; 
if k >1, 
  tC = C.';
  % Force the matrix C to be symmetric -due to finite sample precision, it 
  % may not be the case. 
  C(repmat(1:k,k,1) > repmat(1:k,k,1)')= tC(repmat(1:k,k,1) > repmat(1:k,k,1)'); 
end 