function [gammahat,a,b] = gamell2M(n,p,psi1,gammahat0,realdata)
% Computes the Ell2-estimate of sphericity needed by -Ell2 estimators of
% shrinkage M-estimators
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

a = (n/(n+psi1-1))*psi1;

if realdata 
    b = (n/(n-1))*(n+psi1-1)/(n+3*psi1-1);
else
    b = (n/(n-1))*(n+psi1-1)/(n+2*psi1-1);
end

gammahat    = b*(gammahat0-a*(p/n));
gammahat    = min(p,max(1,gammahat)); % NOTE:\gamma in [1, p];