function [gammahat,kappahat] = gamell2(X,kappahat,eta,is_centered)
% Computes the Ell2-estimate of sphericity needed by ELL2-RSCM estimator
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[n,p] = size(X);
if nargin < 4
    is_centered = false;
end

if nargin < 3
    % center data
    eta = zeros(1,2);
    if ~is_centered
        xbar = mean(X);
        X = X - repmat(xbar,n,1);
    end
    S =  (1/(n-1))*(X')*X;  % unbiased SCM   
    eta(1) = trace(S)/p;
    eta(2) = trace(S^2)/p;
end

if nargin < 2
    kappahat = ellkurt(X,xbar);
end

% estimates of the statistical measures
gammahat0   = eta(2)/eta(1)^2;
a           = (n/(n+kappahat))*(n/(n-1)+kappahat);
b           = (kappahat+n)*(n-1)^2/((n-2)*(3*kappahat*(n-1)+ n*(n+1)));
gammahat    = b*(gammahat0-a*(p/n));
gammahat    = min(p,max(1,gammahat)); % NOTE:\gamma in [1, p];

