function  yhat = LDA(Xt,mu,B,pr)
% LDA computes the estimates of class labels based on the 
% linear discriminant analysis (LDA) rule.  
%
% Inputs: 
%     Xt       test data set of size Nt x p. 
%     mu       matrix of size p x G having class sample mean vectors as 
%               columns.        
%     B        p x K matrix coefficient matrix B = S^-1 M, where  S is the
%              pooled covariance and M is the p x K matrix of class means
% optional inputs:
%     pr       optional class a priori probabilities (a vector of size 1xK)
%              Elements of pr are in [0,1] and should sum to 1. Defaul value 
%              is pr = (1/K, ..., 1/K). 
%
% Outputs: 
%     yhat      estimated class labels 
%
% toolbox: RegularizedSCM ({esa.ollila,elias.raninen}@aalto.fi)
%--------------------------------------------------------------------------

K = size(B,2);

if  nargin < 4 
    pr = 1/K * ones(1,K); % equal prior by default
end

%% Predict the labels of test data
const = -0.5*sum(mu.*B) + log(pr); % 1xK vector of constant in LDA disc. fnc
dlda = Xt*B + const;% scores
[~,yhat] = max(dlda,[],2);
