#include "nrutils.h"
#include <stdio.h>
#define ERROR(expr) { fprintf(stderr,"\n ***** ERROR : " #expr "\n\n"); exit(3);}
#define SMALL 1.0e-9 /* accuracy of determinant calculations */
#define SIGN(a) ((a) > 0 ? 1 : -1)
enum Type { INT,POS_INT,YES_NO,STRING,ULONG};

/* functions for RCM regression */
void OjaRanks(double **data,double **score,int n,int k);
void Nextp(int n, int k, int *p, int *lc);
void RCMReg(double **B,double **cov,int n,int k,int nry);
void RCM(double **score,double **cov,int nrow, int ncol);
void Bootstrap(double **err,double **B,double **data,int n,int k,int nry,int nrboot);
void Set_Seed(long *idum);
/* NR functions */
int ludcmp(double **a, int n, int *indx, double *d);
void lubksb(double **a, int n, int *indx, double b[]);
double ran1(long *idum);
/* General utilities */
void Print_Results(double **B,double **cov,double **err,double **score,int n,int k,int nry,int boot);
void Print_Coefs_and_Errors(FILE *fp,double **B,double **err,int nry,int k,int boot);
unsigned long StringExists(char *s, int argc,char *argv[]);
FILE *OpenFile(char name[], char mode[]);
void Get_Input(char *prompt, void *val,enum Type type);






