#include <malloc.h>
#include <stdio.h>
#define NR_END 1
#define FREE_ARG char* 

void nrerror(char error_text[])
{
	void exit();

	fprintf(stderr,"Numerical Recipes run-time error...\n");
	fprintf(stderr,"%s\n",error_text);
	fprintf(stderr,"...now exiting to system...\n");
	exit(1);
}

float *vector(int nl, int nh)
{
	float *v;

	v=(float *)malloc((size_t)((nh-nl+1+NR_END)*sizeof(float)));
	if (!v) nrerror("allocation failure in vector()");
	return v-nl+NR_END;
}

double *dvector(int nl, int nh)
{
	double *v;

	v=(double *)malloc((size_t)((nh-nl+1+NR_END)*sizeof(double)));
	if (!v) nrerror("allocation failure in dvector()");
	return v-nl+NR_END;
}

int *ivector(long nl, long nh)
{
	int *v;
	
        v=(int*)malloc((size_t)((nh-nl+1+NR_END)*sizeof(int)));
        if (!v) nrerror("allocation failure in vector()");
	return v-nl+NR_END;
}

int **imatrix(long nrl, long nrh, long ncl, long nch)
{
	long i, nrow=nrh-nrl+1,ncol=nch-ncl+1;
	int **m;

	/*allocate pointers to rows */
	m = (int**) malloc((size_t)(nrow+NR_END)*sizeof(int*));
	if (!m) nrerror("allocation failure 1 in matrix()");
	m += NR_END;
	m -= nrl;

	/* allocate rows and set pointers to them */
	m[nrl]=(int *)malloc((size_t)((nrow*ncol+NR_END)*sizeof(int)));
	if (!m[nrl]) nrerror("allocation failure 2 in matrix()");
	m[nrl] += NR_END;
	m[nrl] -= ncl;

	for (i=nrl+1;i<=nrh;i++) m[i]=m[i-1]+ncol;

	/* return pointer to array of pointers to row */
    return m;
}

double **dmatrix(long nrl, long nrh, long ncl, long nch)
{
	long i, nrow=nrh-nrl+1,ncol=nch-ncl+1;
	double **m;

	/*allocate pointers to rows */
	m = (double**) malloc((size_t)(nrow+NR_END)*sizeof(double*));
	if (!m) nrerror("allocation failure 1 in matrix()");
	m += NR_END;
	m -= nrl;

	/* allocate rows and set pointers to them */
	m[nrl]=(double *)malloc((size_t)((nrow*ncol+NR_END)*sizeof(double)));
	if (!m[nrl]) nrerror("allocation failure 2 in matrix()");
	m[nrl] += NR_END;
	m[nrl] -= ncl;

	for (i=nrl+1;i<=nrh;i++) m[i]=m[i-1]+ncol;

	/* return pointer to array of pointers to row */
	return m;
}


float **matrix(long nrl, long nrh, long ncl, long nch)
{
	long i, nrow=nrh-nrl+1,ncol=nch-ncl+1;
	float **m;

	/*allocate pointers to rows */
	m = (float**) malloc((size_t)(nrow+NR_END)*sizeof(float*));
	if (!m) nrerror("allocation failure 1 in matrix()");
	m += NR_END;
	m -= nrl;

	/* allocate rows and set pointers to them */
	m[nrl]=(float *)malloc((size_t)((nrow*ncol+NR_END)*sizeof(float)));
	if (!m[nrl]) nrerror("allocation failure 2 in matrix()");
	m[nrl] += NR_END;
	m[nrl] -= ncl;

	for (i=nrl+1;i<=nrh;i++) m[i]=m[i-1]+ncol;

	/* return pointer to array of pointers to row */
    return m;
}
 
unsigned long *lvector(long nl, long nh)
/* allocate an unsigned long vector with subscript range v[nl..nh] */
{
	unsigned long *v;
	v=(unsigned long *)malloc((size_t)((nh-nl+1+NR_END)*sizeof(long)));
	if (!v) nrerror("allocation failure in lvector()");
	return v-nl+NR_END;
}


void free_vector(float *v, int nl, int nh)
{
	free((FREE_ARG)(v+nl-NR_END));
}

void free_dvector(double *v, int nl, int nh)
{
	free((FREE_ARG)(v+nl-NR_END));
}

void free_ivector(int *v, int nl, int nh)
{
	free((FREE_ARG)(v+nl-NR_END));
}

void free_lvector(unsigned long *v, long nl, long nh)
{
    free((FREE_ARG)(v+nl-NR_END));
}

void free_imatrix(int **m, long nrl, long nrh, long ncl, long nch)
{
	free((FREE_ARG)(m[nrl]+ncl-NR_END));
        free((FREE_ARG)(m+ncl-NR_END));
}

void free_matrix(float **m, long nrl, long nrh, long ncl, long nch)
{
	free((FREE_ARG)(m[nrl]+ncl-NR_END));
        free((FREE_ARG)(m+ncl-NR_END));
} 
void free_dmatrix(double **m, long nrl, long nrh, long ncl, long nch)
{
	free((FREE_ARG)(m[nrl]+ncl-NR_END));
        free((FREE_ARG)(m+ncl-NR_END));
} 
