function Xo = crda_check_data(Xo,yo,print_info)
% Check data for missing values in classes or zero vectors.
% CRDA MATLAB toolbox,  (c) E. Ollila and M.N Tabassum
    
n = histcounts(yo);
G  = max(yo);

%% if all values on any variable are missing, then delete that variable
Xo  = Xo(~(sum(isnan(Xo),2)==size(Xo,2)),:);
% percentage of missing values
nr_nan = 100*sum(sum(isnan(Xo),2))/numel(Xo);
if print_info
     fprintf('percentage of missing values = %.2f\n',nr_nan);
end
    
%% if a variable is missing in a single class then delete that variable

if nr_nan ~= 0
    for ii=1:G
        ind = sum(isnan(Xo(:,yo==ii)),2) == n(ii);
        if sum(ind) ~= 0
            if print_info
                fprintf('a variable missing in a class %d\n',ii);
            end
            Xo = Xo(~ind,:);
        end
    end
end
    
%% Delete the vector of all zeros:
% assuming that they are missing information or non-informative
p = size(Xo,1);
onetop = 1:p;
% Check if all recordings on any variable has a constant value 
index=any(Xo-nanmean(Xo,2),2); 
if ~all(index) 
    fprintf('a variable has a constant recording on observations\n');
end      
allzeros=onetop(~index);
Xo = Xo(setdiff(onetop,allzeros),:);